<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Services\WalletService;
use App\Services\MatchingEngineService;
use App\Services\SettlementService;
use App\Models\Order;
use DB;

class OrderController extends Controller {
    public function create(Request $r) {
        return DB::transaction(function() use ($r) {
            $o = Order::create($r->all());
            $trades = MatchingEngineService::match($o);
            SettlementService::run($trades);
            return ['order'=>$o,'trades'=>$trades];
        });
    }
    public function cancel($id) {
        $o = Order::findOrFail($id);
        return ['status'=>'cancelled'];
    }
}
